using System;
using System.Collections.Generic;

class Solution
{
    static void Main()
    {
        // Citamo ukupan broj tacaka 'n'
        int n = int.Parse(Console.ReadLine());

        var diag1 = new Dictionary<long, long>(); // x + y (glavna dijagonala)
        var diag2 = new Dictionary<long, long>(); // x - y (sporedna dijagonala)

        // y -> [countParity0, countParity1] for x%2
        var sameY = new Dictionary<long, long[]>(); 
        // x -> [countParity0, countParity1] for y%2
        var sameX = new Dictionary<long, long[]>(); 

        for (int i = 0; i < n; i++)
        {
            // Citamo liniju, razdvajamo string po razmacima
            string[] s = Console.ReadLine().Split();
            long x = long.Parse(s[0]);
            long y = long.Parse(s[1]);

            long d1 = x + y;
            long d2 = x - y;

            // Inkrementiranje dijagonala koristeci TryGetValue (cistiji nacin od if/else)
            if (!diag1.TryGetValue(d1, out long v1)) v1 = 0;
            diag1[d1] = v1 + 1;

            if (!diag2.TryGetValue(d2, out long v2)) v2 = 0;
            diag2[d2] = v2 + 1;
            
            // Racunanje parnosti koristeci bitovnu operaciju & 1L
            long px = (x & 1L); 
            long py = (y & 1L);

            // Inkrementiranje head-on brojeva za isti Y
            if (!sameY.TryGetValue(y, out long[] arrY)) {
                arrY = new long[2];
                sameY[y] = arrY;
            }
            arrY[px]++;

            // Inkrementiranje head-on brojeva za isti X
            if (!sameX.TryGetValue(x, out long[] arrX)) {
                arrX = new long[2];
                sameX[x] = arrX;
            }
            arrX[py]++;
        }

        long result = 0;

        // Racunanje parova na dijagonalama (k*(k-1) za 2 susreta po paru)
        foreach (var kv in diag1) {
            long k = kv.Value;
            if (k > 1) result += k * (k - 1);
        }
        foreach (var kv in diag2) {
            long k = kv.Value;
            if (k > 1) result += k * (k - 1);
        }

        // Racunanje head-on sudara na istom Y (C(c0,2) + C(c1,2))
        foreach (var kv in sameY) {
            long c0 = kv.Value[0];
            long c1 = kv.Value[1];
            if (c0 > 1) result += c0 * (c0 - 1) / 2;
            if (c1 > 1) result += c1 * (c1 - 1) / 2;
        }

        // Racunanje head-on sudara na istom X (C(c0,2) + C(c1,2))
        foreach (var kv in sameX) {
            long c0 = kv.Value[0];
            long c1 = kv.Value[1];
            if (c0 > 1) result += c0 * (c0 - 1) / 2;
            if (c1 > 1) result += c1 * (c1 - 1) / 2;
        }

        Console.WriteLine(result);
    }
}